/*  Manuelle Einterminiung eines gegebenen AG in einem vorgebenen Zeitfenster.

    Beim Eintragen der Zeitblöcke auf der Hauptressource und ggf. der KKS werden Maschinenausschaltzeiten und auch andere schon
    vorhandene Terminierungen auf den entsprechenden Ressourcen ignoriert und die Blöcke direkt mit dem Vorgabezeitraum in die
    Tabelle scheduling.resource_timeline eingetragen. Überschreiten diese Blöcke Tagesgrenzen, werden diese Blöcke in jeweils
    einen Block pro Tag aufgeteilt. Diese haben dann eine kleinen Lücke von 23:59:59 Uhr bis 0:00:00 Uhr. */

/*    -- TODO komplett auskommentiert. DROP? > DROP IF EXISTS ?
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__ab2__termination_manual(
      _ab2_id                 integer,
      _termination_start_time timestamp,
      _termination_end_time   timestamp,
      _loglevel int DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
  ) RETURNS void LANGUAGE plpgsql AS $$

  DECLARE

        _prefix                   varchar = format( 'scheduling.resource_timeline__ab2__termination_manual AG %L -', _ab2_id );
        _resource_id_HR           integer;       -- RessourceID der genutzten Hauptressource.
        _resource_id_target       integer;       -- RessourceID der Vorgabe der zu verwendeten Hauptressource.
        _resource_id_KKS          integer;       -- RessourceID der Kopfkostestelle.
        _ta_kf_HR                 numeric(16,8); -- Kuorekturfaktor für die Arbeitsplatzgeschwindigkeit.
        _daysdiff                 integer;       -- Differnz der Kalendertage zwischen Anfangs- und Endzeit des manuellen Vorgabezeitraums
        _date_start               timestamp;     -- jeweilige Startezeitpunkt eines Terminierunseintrags
        _date_end                 timestamp;     -- jeweiliger Endzeitpunkt eines Terminierunseintrags
        _ti_type                  scheduling.resource_timeline_blocktype;

  BEGIN

      -- Tagesdiffenz zwischen Anfangs- und Endzeit des Vorgabezeitraums ermitteln.
      _daysdiff := _termination_end_time::date - _termination_start_time::date;
      -- Debug
      IF _loglevel >= 4 THEN
          RAISE NOTICE '% Manuelle Terminvorgabe: daysdiff = %;', _prefix, _daysdiff;
      END IF;

      -- Ressource-ID der Hauptressource auf dem der AG terminiert wurde.
      SELECT a2w_resource_id_main_terminated,
             a2w_resource_id_main_fix
        INTO _resource_id_HR,
             -- RessourceID der Vorgabe der zu verwendeten Hauptressource.
             _resource_id_target
        FROM ab2_wkstplan
       WHERE a2w_a2_id = _ab2_id;

      -- Der AG ist bereits terminiert.
      IF _resource_id_HR IS NOT null THEN
          -- Alle überflüssig gewordenen Terminierungseinträge (Hauptressource + KKS) löschen. Diese werden später alle mit dem manuellen Vorgabezeitfenster neu angelegt.
          --PERFORM scheduling.abk__termination_clear( _a2_ids => ARRAY[ _ab2_id ], _resource_id_main_fix__Reset => false );
          DELETE
            FROM scheduling.resource_timeline
           WHERE ti_a2_id = _ab2_id
          ;
      END IF;

      -- Eine der möglichen alternative Arbeitsplatzressourcen auswählen. Vorgabe oder schnellsten unter den am wenigsten belegeten Arbeitsplätzen.
      -- TODO AXS: Hier ebenfalls Vorgabe aus ab2_wkstplan.a2w_resource_id_main_fix beachten.
      SELECT coalesce( _resource_id_target, o.resource_id )
      INTO _resource_id_HR
      FROM (
              SELECT r.id AS resource_id
                   , sum( tsystem.get_timerange_intersection_duration( tsrange( ti_date_start, ti_date_end, '()' ), tsrange( a2_at, a2_et, '()' ) ) ) / ( 60 * 60 ) AS occupation_duration
                FROM ksvba
                JOIN scheduling.resource r ON r.context_id = ksb_id
                                          AND r.context = 'ksvba'
                JOIN ab2 ON a2_id = _ab2_id
                LEFT JOIN scheduling.resource_timeline ON ti_resource_id = r.id
                                                      AND ti_type IN ( 'task', 'task.blocktime', 'task.buffer' )
                                                      AND tsrange( ti_date_start, ti_date_end, '()' ) && tsrange( a2_at, a2_et, '()' )
               WHERE ksb_id = any ( scheduling.ab2__resources__find_possible__ksvba_ksb_id__by__ab2__get( _ab2_id ) ) -- TODO AXS nur in abk hinterlegte, nicht aus ASK! Neue Funktion für alle in aktuellen Optionen
               GROUP BY r.id, ksb_ks_ba
               ORDER BY occupation_duration ASC, ksb_ks_ba DESC
            ) o
      LIMIT 1;

      IF _loglevel >= 5 THEN
          RAISE NOTICE '% resource_id_HR: %;', _prefix, _resource_id_HR;
      END IF;

      -- Korrekturfaktor für die Geschwindigkeit der Arbeitsplatzressource bestimmen.
      SELECT r.ta_fk
        INTO _ta_kf_HR
        FROM scheduling.resource r
       WHERE r.id = _resource_id_HR
         AND r.context = 'ksvba';

      IF TSystem.ENUM_ContainsValue(ab_stat, 'BUFFER') FROM abk, ab2 WHERE ab_ix = a2_ab_ix AND a2_id = _ab2_id THEN
         _ti_type := 'task.buffer';
      ELSE
         _ti_type := 'task';
      END IF;

      -- Einträge für Terminierung der Hauptressource erstellen.
      FOR i IN 0.._daysdiff LOOP
          _date_start := date_trunc( 'day', _termination_start_time ) + i * interval '1 day';
          _date_end   := date_trunc( 'day', _termination_start_time ) + i * interval '1 day' + interval '23 hours' + interval '59 minutes' + interval '59 seconds';
          IF i = 0 THEN
              _date_start := _termination_start_time;
          END IF;
          IF i = _daysdiff THEN
              _date_end := _termination_end_time;
          END IF;
          -- Debug
          IF _loglevel >= 5 THEN
              RAISE NOTICE '% Manuelle Terminvorgabe HR: loop = %, resource_id = %,date_start = %, date_end = %, ta_kf = %;', _prefix, i, _resource_id_HR, _date_start, _date_end, _ta_kf_HR;
          END IF;
          INSERT INTO scheduling.resource_timeline( ti_a2_id , ti_resource_id , ti_date_start, ti_date_end, ti_type, ti_ta_kf  )
          VALUES                                  ( _ab2_id, _resource_id_HR, _date_start  , _date_end  , _ti_type , _ta_kf_HR );
      END LOOP;

      -- ResourceID der KKS.
      SELECT scheduling.resource__top_resource_id__get( _resource_id_HR )
      INTO _resource_id_KKS;

      -- Es gibt eine KKS.
      IF _resource_id_KKS IS NOT null THEN

          -- Einträge für Terminierung der KKS erstellen.
          FOR  i IN 0.._daysdiff LOOP
              _date_start := date_trunc( 'day', _termination_start_time ) + i * interval '1 day';
              _date_end   := date_trunc( 'day', _termination_start_time ) + i * interval '1 day' + interval '23 hours' + interval '59 minutes' + interval '59 seconds';
              IF i = 0 THEN
                  _date_start := _termination_start_time;
              END IF;
              IF i = _daysdiff THEN
                  _date_end := _termination_end_time;
              END IF;
              -- Debug
              IF _loglevel >= 5 THEN
                  RAISE NOTICE '% Manuelle Terminvorgabe KKS: loop = %, resource_id = %,date_start = %, date_end = %, ta_kf = %;', _prefix, i, _resource_id_KKS, _date_start, _date_end, _ta_kf_HR;
              END IF;
              INSERT INTO scheduling.resource_timeline( ti_a2_id , ti_resource_id  , ti_date_start, ti_date_end, ti_type, ti_ta_kf  )
              VALUES                                  ( _ab2_id, _resource_id_KKS, _date_start  , _date_end  , _ti_type , _ta_kf_HR );
          END LOOP;

      END IF;

      -- Die bei der manuellen Terminierung des AGs verwendete Hauptressource in der Spalte "a2w_resource_id_main_terminated"
      -- merken.
      -- Zusätzlich die verwendete Hauptressource als Vorgabe für die nächste Terminierungen des entsprechenden AGs in der
      -- Spalte a2w_resource_id_main_fix hinterlegen. Soll eine andere Ressource bei der nächsten Termineriung verwendet werden,
      -- muss aus der Oberfläche heraus die Vorgabe entsprechend angepasst werden.
      UPDATE ab2_wkstplan
        SET a2w_resource_id_main_terminated = scheduling.resource_timeline__resource_id_main_resource__get( _ab2_id )
          , a2w_resource_id_main_fix        = scheduling.resource_timeline__resource_id_main_resource__get( _ab2_id )
      WHERE a2w_a2_id = _ab2_id;

  END $$;
--
*/

SELECT true;